<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

trait AccessPrivate {

	private static $ancestorReflectionClasses = null;

	private static function getAncestorReflectionClasses()
	{
		if (is_null(self::$ancestorReflectionClasses)) {
			$parentClasses = class_parents(self::class);
			self::$ancestorReflectionClasses=[];
			foreach ($parentClasses as $parentClass) {
				self::$ancestorReflectionClasses[] = new \ReflectionClass($parentClass);
			}
		}
		return self::$ancestorReflectionClasses;
	}

	private static function findParentReflectProperty($property)
	{
		$ancestorReflectionClasses = self::getAncestorReflectionClasses();
		foreach ($ancestorReflectionClasses as $ancestorReflectionClass) {
			if ($ancestorReflectionClass->hasProperty($property)) {
				return $ancestorReflectionClass->getProperty($property);
			}
		}
		throw new \ReflectionException("Property '".$property."' does not exist as an attribute of ".self::class." or it's parents");
	}

	private static function findParentReflectMethod($property)
	{
		$ancestorReflectionClasses = self::getAncestorReflectionClasses();
		foreach ($ancestorReflectionClasses as $ancestorReflectionClass) {
			if ($ancestorReflectionClass->hasMethod($property)) {
				return $ancestorReflectionClass->getMethod($property);
			}
		}
		throw new \ReflectionException("Property '".property."' does not exist as an method of ".self::class." or it's parents");
	}

	public function __call($method, $args)
	{
		$reflectMethod = self::findParentReflectMethod($method);
		if ($reflectMethod->isPrivate()) {
			$reflectMethod->setAccessible(true);
		}
		return $reflectMethod->invokeArgs($this, $args);
	}

	public function __get($name)
	{
		$reflectProperty = self::findParentReflectProperty($name);
		if ($reflectProperty->isPrivate()) {
			$reflectProperty->setAccessible(true);
		}
		return $reflectProperty->getValue($this);
	}

	public function __set($name, $value)
	{
		$reflectProperty = self::findParentReflectProperty($name);
		if ($reflectProperty->isPrivate()) {
			$reflectProperty->setAccessible(true);
		}
		return $reflectProperty->setValue($this,$value);
	}

	public static function __callStatic($name, $args)
	{
		$reflectStaticMethod = self::findParentReflectMethod($name);
		if ($reflectStaticMethod->isPrivate()) {
			$reflectStaticMethod->setAccessible(true);
		}
		return $reflectStaticMethod->invokeArgs(null, $args);
	}
}



class CGrandparent
{
	private $unavailableGrandparentAttribute = 'grandparentPrivateAttribute';

	private static function gp_staticPrivateMethod() {
		echo "gp_staticPrivateMethod<br>";
	}

	private function gp_privateMethod() {
		echo "gp_privateMethod<br>";
	}
}


class CParent extends CGrandparent
{
	private $unavailableParentAttribute = 'parentPrivateAttribute';

	private static function p_staticPrivateMethod() {
		echo "p_staticPrivateMethod<br>";
	}

	private function p_privateMethod() {
		echo "p_privateMethod<br>";
	}
}

class CTest extends CParent
{
	use AccessPrivate;
}

$ctest = new CTest();
// parent hidden stuff
echo "parent's hidden stuff:<br>";
echo $ctest->unavailableParentAttribute."<br>";
$ctest->unavailableParentAttribute='changed parent attribute';
echo $ctest->unavailableParentAttribute."<br>";
CTest::p_staticPrivateMethod();
$ctest->p_privateMethod();
// grandparent hidden stuff
echo "<br>grandparent's hidden stuff:<br>";
echo $ctest->unavailableGrandparentAttribute."<br>";
$ctest->unavailableGrandparentAttribute='changed grandparent attibute';
echo $ctest->unavailableGrandparentAttribute."<br>";
CTest::gp_staticPrivateMethod();
$ctest->gp_privateMethod();

